import pandas as pd  
import matplotlib.pyplot as plt  
  
# Load the dataset  
credit_customers = pd.read_csv("credit_customers.csv")  
  
# Filter customer segments  
middle_aged_customers = credit_customers[(credit_customers['age'] > 40) & (credit_customers['age'] < 59)]  
stable_employment_customers = credit_customers[credit_customers['employment'].isin(['>=7', '4<=X<7'])]  
good_credit_history_customers = credit_customers[credit_customers['credit_history'].isin(['existing paid', 'no credits/all paid', 'all paid'])]  
  
# Calculate approval rates  
approval_rates_middle_aged = middle_aged_customers['class'].value_counts(normalize=True)  
approval_rates_stable_employment = stable_employment_customers['class'].value_counts(normalize=True)  
approval_rates_good_credit_history = good_credit_history_customers['class'].value_counts(normalize=True)  
  
# Plot pie charts  
fig, axes = plt.subplots(1, 3, figsize=(18, 6))  
  
approval_rates_middle_aged.plot(kind='pie', ax=axes[0], autopct='%.1f%%', startangle=90, ylabel='')  
axes[0].set_title('Loan Approval Rates for Middle-Aged Customers (40-59)')  
  
approval_rates_stable_employment.plot(kind='pie', ax=axes[1], autopct='%.1f%%', startangle=90, ylabel='')  
axes[1].set_title('Loan Approval Rates for Customers with Stable Employment')  
  
approval_rates_good_credit_history.plot(kind='pie', ax=axes[2], autopct='%.1f%%', startangle=90, ylabel='')  
axes[2].set_title('Loan Approval Rates for Customers with Good/Excellent Credit History')  
  
plt.tight_layout() 
plt.savefig('ref_result/pieplot.png') 
plt.show()  